//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------
#ifndef( UNI_Povray_Stars_Temp)
	#declare UNI_Povray_Stars_Temp = version;
	#version 3.7;
	#ifndef(  Colors_Inc_Temp)			#include "colors.inc"		#end
	#ifndef(  Textures_Inc_Temp)		#include "textures.inc"		#end
	//Here we're still inside an If-Block !! (the first #ifndef)
//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------

/* ****************************************************************************************************************************

--------------------------------------------------------
MA_Tussi_V1
--------------------------------------------------------
Purpose:		Show a simple, small, fast to render Spacecraft
Author:			Martin Seydler
Website:		www.maetes.com
Documentation:	www.maetes.com/en/povray-os/ma_tussi_v1
				www.maetes.com/de/povray-os/ma_tussi_v1
Date:			2018 an later
Version:		1.0 (13. May 2019)
Copyright:		See above (author)
License:		With my code you can do with it whatever you like.
				A mention and a link to my website would be nice, and a hint where to see your results.


Helpful Command-Lines (change the path):
------------------------------------------
povray +Ima_universe_stars_v1.inc +O_test/ma_universe_stars.png +w800 +h600 -GR +A
povray +Ima_universe_stars_v1.inc +O_test/ma_universe_stars.png +w1200 +h800 +GD +GF -GR +GS +GW +Q9 +A


To open the resulting picture in a Browser (change the path):
-----------------------------------------------------
file:///home/pi/Projekte/povray/bibs/ma_universe_stars_v1/_test/ma_universe_stars.png
file:///home/pi/Projekte/povray/bibs/ma_universe_stars_v1/_test/


*/// **************************************************************************************************************************



/* ----------------------------------------------------------------------------------------------------------------------------
Declaring some variables

There is no need to change the values here, these are defaults only.
Instead do this in your including-script, bevor you include this file.
	
UNI_Stars_Rotation
	To rotate the whole object of Stars, Borders and Lines.
	<0,-90,0> will place longitude = 0 at the positive end of the Z-Vector
	In this case cam <0,0,0> and look_at <0,0,1> will show 0-longitude or Constellation Pegasus.
	<0,0,0> will place longitude = 0 at positive-X and constellation Orion at positive-Z.
	
UNI_Stars_Distance
	The Radius of the Sphere, that contains all Stars, Borders and Lines.
	1000 is ok, 10000 also, but beyond rendering-time will raise dramatically (dont know why, maybe to many and to big sphere-objects?)
	Dont forget, the size of the stars increases with its distance, to be to the camera about the same size, independendly of the distance.
	To set a View-Order, constellation-lines will add 1 % and -borders 2 %, so no important star will get lost behind lines.

UNI_Stars_Distance_Org
	DONT CHANGE THIS VALUE!
	The difference between UNI_Stars_Distance and UNI_Stars_Distance_Org gets used to correct the star-size and border/lines thickness.
	Without all this maybe will disappear, because same-size Objects at bigger Distance will appear smaller, maybe smaller than a Pixel.

UNI_Stars_CamAngle
UNI_Stars_CamAngle_Org
	The same as UNI_Stars_Distance*.
	All Elements (stars, lines, borders) are optimized for cam- and viewangle of 90 degrees.
	You should always set UNI_Stars_CamAngle to the same value as "camera { ... angle 0-180} to get roughly the same Stars-Sizes at all angles.

UNI_Stars_StarsSizeFactor
	Use this to alter the visible size of the stars.
	This variable does not represent the real size, it only helps to calculate it.
	Bigger factor means bigger stars (and maybe higher rendering-time).
	Maybe 2 or 3 for nice backgrounds, 5 or bigger to identify constellations.

UNI_Stars_Milkiway_Size	
	Changes the width of the Milkiway
UNI_Stars_Milkiway_Intensity
	Brightens the Milkiway
	
UNI_Stars_ConstLineSizeFactor
UNI_Stars_ConstBorderSizeFactor
	Almost the same as UNI_Stars_StarsSizeFactor, but size here means thickness.
	
UNI_Stars_StarsMinMag
	Defines the darkest star to be rendered (minimum magnitude). Everything darker will be ignored (faster rendering-time).
	Beware: The higher the number, the darker the star!
	-1 are the brightest, +6 visible by naked eye, +10 only visible by telescope, +18 are the darkest in the database
	Number of stars raising by exponent 2 with darkness (or ex 4?).
	
UNI_StarTextureSimple
UNI_ConstBordersTexture
UNI_ConstLinesTexture
	As the names says, the textures of them.
	
*/// --------------------------------------------------------------------------------------------------------------------------

#ifndef( UNI_Stars_Rotation )				#declare UNI_Stars_Rotation					= <0,0>;						#end

#ifndef( UNI_Stars_RotationY )				#declare UNI_Stars_RotationY				= 0;							#end //float
#ifndef( UNI_Stars_RotationX )				#declare UNI_Stars_RotationX				= 0;							#end //float

#ifndef( UNI_Stars_Distance )				#declare UNI_Stars_Distance					= 1000;							#end
#ifndef( UNI_Stars_Distance_Org )			#declare UNI_Stars_Distance_Org				= 1000;							#end //dont change!

#ifndef( UNI_Stars_CamAngle )				#declare UNI_Stars_CamAngle					= 90;							#end
#ifndef( UNI_Stars_CamAngle_Org )			#declare UNI_Stars_CamAngle_Org				= 90;							#end //dont change!

#ifndef( UNI_Stars_ConstLineSizeFactor )	#declare UNI_Stars_ConstLineSizeFactor		= 0.5;							#end
#ifndef( UNI_Stars_ConstBorderSizeFactor )	#declare UNI_Stars_ConstBorderSizeFactor	= 0.8;							#end

#ifndef( UNI_Stars_StarsMinMag )			#declare UNI_Stars_StarsMinMag				= 10;							#end

#ifndef( UNI_Stars_StarsSizeFactor )		#declare UNI_Stars_StarsSizeFactor			= 2.5;							#end
#ifndef( UNI_Stars_Milkiway_Size )			#declare UNI_Stars_Milkiway_Size			= 5;							#end
#ifndef( UNI_Stars_Milkiway_Intensity )		#declare UNI_Stars_Milkiway_Intensity		= 0.05;							#end

#ifndef( UNI_ConstBordersTexture)			#declare UNI_ConstBordersTexture =
	texture {
		pigment		{ color rgb <0.5,0.5,0.5> }
		finish		{ ambient 1 diffuse 0 reflection 0 phong 0 specular 0 crand 0 }
	}
#end
#ifndef( UNI_ConstLinesTexture)				#declare UNI_ConstLinesTexture =
	texture {
		pigment		{ color rgb <0.05,0.05,0.2> }
		finish		{ ambient 1 diffuse 0 reflection 0 phong 0 specular 0 crand 0 }
	}
#end
#ifndef( UNI_StarTextureSimple )			#declare UNI_StarTextureSimple =
	texture { 
		pigment		{ color rgb <1,1,1> }
		finish		{ ambient 1 diffuse 0 reflection 0 phong 0 specular 0 crand 0 }
	}
#end




/* ****************************************************************************************************************************

UNI_GetStars

First tests with a real starfield.

Params:
	- none at the moment -
Return:
	The object, a sphere-like object that contains all stars (which are objects also)
*/// **************************************************************************************************************************
#macro UNI_GetStars ( )

	#local mResult = union {
		#for (mIndex, 0, dimension_size(UNI_StarsData,1) - 1)
			//#local mID			= val(UNI_StarsData[mIndex][sss_id]);
			//#local mName		=     UNI_StarsData[mIndex][sss_name];
			#local mDistance	= val(UNI_StarsData[mIndex][sss_dist]);
			#local mMagEarth	= val(UNI_StarsData[mIndex][sss_mage]);
			#local mMagAbs		= val(UNI_StarsData[mIndex][sss_maga]);
			#local mRect		= val(UNI_StarsData[mIndex][sss_rect]);
			#local mDecl		= val(UNI_StarsData[mIndex][sss_decl]);
			#local mColor	= color rgb <val(UNI_StarsData[mIndex][sss_colr]), val(UNI_StarsData[mIndex][sss_colg]), val(UNI_StarsData[mIndex][sss_colb])>;

			#if ( mMagEarth < UNI_Stars_StarsMinMag )
				//#local mTotalMag	= 2.450 + mMagEarth; //so the brightes Stars are at 0 and the darkest > 10
				#local mTotalMag	= mMagEarth;
				#if ( mMagEarth < 1 )
					#local mTotalMag = 1; //Shrink all the biggest Stars to the same brightness (if Factor = 1 then we're talking about 16 Stars)
				#end
				
				#local mStarSize	= 2 / pow(mTotalMag,1.1);
				#local mStarSize	= UNI__GetRealSBLSize(mStarSize)

				//#local mStarSize	= 2 / mTotalMag,1.8);
				#local mDistance	= UNI_Stars_Distance;
				#local mPoint		= MA_Deg2Vector01(mRect, mDecl, mDistance);
				object {
					object {
						UNI__GetStar(mStarSize, mColor)
					}
					translate mPoint
				}
			#end
		#end
	}

	//object { mResult rotate y*UNI_Stars_RotationY rotate x*UNI_Stars_RotationX }
	//object { mResult rotate y*UNI_Stars_Rotation.y rotate x*UNI_Stars_Rotation.x }
	object { mResult rotate y*UNI_Stars_Rotation.x rotate x*-UNI_Stars_Rotation.y }
#end


/* ****************************************************************************************************************************

UNI_GetConstBorders

Return:
	The object, a sphere-like object that contains the lines BETWEEN the constellations
*/// **************************************************************************************************************************
#macro UNI_GetConstBorders ()

	#local mRadius		= UNI_Stars_Distance * 1.02;

	#local mResult = union {
		#local mNameLast	= "";
		#for (mIndex, 0, dimension_size(UNI_ConstBordersData,1) - 1)
			#local mNameAct		= strlwr(UNI_ConstBordersData[mIndex][0]);
			
			//#if (mNameAct = "uma" | mNameAct = "cas")
			#if (1) //all
				#local mRect = val(UNI_ConstBordersData[mIndex][1]);
				#local mDecl = val(UNI_ConstBordersData[mIndex][2]);
				#local mPointAct = MA_Deg2Vector01(mRect, mDecl, mRadius);
				
				#if (mNameLast = "")				//Very first loop
					#local mPointFirst	= mPointAct;
				#elseif (mNameLast != mNameAct)		//New constellation
					object { UNI__GetConstBorder (mPointFirst, mPointLast) }
					#local mPointFirst	= mPointAct;
				#end
				#if (mNameLast = mNameAct)			//Normal line
					object { UNI__GetConstBorder (mPointLast, mPointAct) }
				#end
				#local mPointLast	= mPointAct;
				#local mNameLast	= mNameAct;
			#end
		#end
		//Draw the last Line, wich was forgotten by the loop
		object { UNI__GetConstBorder (mPointFirst, mPointLast) }
	}
	object { mResult rotate y*UNI_Stars_Rotation.x rotate x*-UNI_Stars_Rotation.y	}
#end

/* ****************************************************************************************************************************

UNI_GetConstLines

Return:
	The object, a sphere-like object that contains the lines INSIDE the constellations
*/// **************************************************************************************************************************
#macro UNI_GetConstLines ()

	#local mRadius		= UNI_Stars_Distance * 1.01;
	
	#local mResult = union {
		#for (mIndex, 0, dimension_size(UNI_ConstLinesData,1) - 1)
			#local mRect1	= UNI_ConstLinesData[mIndex][0];
			#local mDecl1	= UNI_ConstLinesData[mIndex][1];
			#local mRect2	= UNI_ConstLinesData[mIndex][3];
			#local mDecl2	= UNI_ConstLinesData[mIndex][4];
			#local mPointAct1 = MA_Deg2Vector01(mRect1, mDecl1, mRadius);
			#local mPointAct2 = MA_Deg2Vector01(mRect2, mDecl2, mRadius);
			object { UNI__GetConstLine (mPointAct1, mPointAct2) }
		#end
	}
	object { mResult rotate y*UNI_Stars_Rotation.x rotate x*-UNI_Stars_Rotation.y }
#end



/* ****************************************************************************************************************************

UNI_GetPigment_*

Some things are no objects, instead they are part of the sky_sphere.
- The Sun
- Milkyway
- Background-Stars

One Reason is, on this way they are much faster to render, especially the sun with a glowing halo.
So dont use them as Objects but add them as below into a sky_sphere.
The last will be the nearest, so be friendly and dont place the sun behind the Milkyway.

Example:
	sky_sphere {
		UNI_GetPigment_Milkyway()
		UNI_GetPigment_BackgroundStars()
	}

Return:
	One pigment, that can combined one after the other.
*/// **************************************************************************************************************************
#macro UNI_GetPigment_Milkyway()

	//Habe hier noch die ganzen alten Variablen-Namen dringelassen.
	//Irgendwann später nochens mit rumspielen, aussortieren, aufräumen.
	
	#local galaxy_intensity			= UNI_Stars_Milkiway_Intensity;		//0 = transparent und nicht vorhanden, 5 sehr dominant, 0.05 default
	#local galaxy_pattern_scale		= 1.6;	//Def = 1.6 - Je höher (10?) umso verschwommenere Nebel, kleiner (<2 mit immer härter umrissenen Nebel-Abgrenzungen)
	#local galaxy_pattern_origin		= <11,0,0>;	//Verschiebt die Nebel-Ansicht? sieht auf jedenfall bei kleinsten verschiebungen sehr anders aus
	#local galaxy_turb_origin			= <0, 10, 0>; //Verändert die Muster in den Nebeln. Verschiebung um 0.1 kann schon ganz anders aussehen! (innerhalb der Nebel, die kleinen Filamente)
	#local _GX_starcolour1 = <1, 1, 1>;
	#local _GX_starcolour2 = _GX_starcolour1 - .3;
	#local _GX_starcolour3 = (_GX_starcolour1 + _GX_starcolour2) / 2;

	#local mResult = pigment {
		function{abs(y)} pigment_map {
			[.03 granite
				color_map {
					[.1 rgb _GX_starcolour3 transmit pow(.9, galaxy_intensity)]
					[.8 rgb _GX_starcolour1 transmit pow(.7, galaxy_intensity)]
				}
				scale .8 * galaxy_pattern_scale translate -galaxy_pattern_origin]
			[.08 granite
				color_map {
					[.4 rgb _GX_starcolour2 transmit 1]
					[1 rgb _GX_starcolour3 transmit pow(.8, galaxy_intensity)]
				}
				scale .6 * galaxy_pattern_scale translate -galaxy_pattern_origin]
			[.1 rgb _GX_starcolour2 transmit 1]
		}
		scale UNI_Stars_Milkiway_Size //5
		translate -galaxy_turb_origin
			warp {
				turbulence .3
				octaves 4
				lambda 3
			}
		translate galaxy_turb_origin
		//Ca: RA 266 und DE -29 Grad.		
		rotate x*-60
		rotate y*-20
	}
	pigment { mResult rotate y*UNI_Stars_Rotation.x rotate x*-UNI_Stars_Rotation.y }
#end

#macro UNI_GetPigment_BackgroundStars()
	#local mResult = pigment {
		bozo
		color_map {
			[0.0 White*3]
			[0.2 Black]
			[1.0 Black]
		}
		scale .0015
	}
	pigment { mResult }
#end

	


/* ****************************************************************************************************************************

Internal macros

*/// **************************************************************************************************************************

//Get real star/border/line-Size
#macro UNI__GetRealSBLSize(mSize)
	#declare UNI_Stars_CamAngle = CamAngle;
	#local mNew	= mSize / UNI_Stars_Distance_Org * UNI_Stars_Distance;
	#local mNew	= mNew  / UNI_Stars_CamAngle_Org * UNI_Stars_CamAngle;
	mNew;
#end
//Get on line of a constellation-BORDER
#macro UNI__GetConstBorder (mV1, mV2)
	#local mThickness	= UNI__GetRealSBLSize(UNI_Stars_ConstBorderSizeFactor);
	#local mResult = cylinder {
		mV1, mV2 * 1.001, mThickness
		texture { UNI_ConstBordersTexture }
	}
	mResult
#end
//Get on line of a constellation-LINE (connecting star)
#macro UNI__GetConstLine (mV1, mV2)
	#local mThickness	= UNI__GetRealSBLSize(UNI_Stars_ConstLineSizeFactor);
	#local mResult = cylinder {
		mV1, mV2, mThickness
		texture { UNI_ConstLinesTexture }
	}
	mResult
#end
//Get one star
#macro UNI__GetStar(mSize, mColor)
	#local mResult = object {
		sphere {
			<0,0,0> mSize * UNI_Stars_StarsSizeFactor
			texture {
				UNI_StarTextureSimple 
				pigment		{ mColor }
			}
		}
	}
	mResult
#end











/* ****************************************************************************************************************************

Example-Output

This will only work if you execute the file directly, instead of including it.
If you use it as an include-file, no output will be generated, all the lines from here on will be useless text.
See:
http://povray.org/documentation/3.7.0/r3_2.html#r3_2_5_2

Nevertheless there is no reason to delete the examples, parsing isnt the thing that slows down the render-process.

*/// **************************************************************************************************************************


#if (input_file_name = "ma_universe_stars_v1.inc")
	
	//#include "../ma_helpers_v1/ma_helpers_v1.inc" //Change this path
	#include "ma_helpers_v1.inc" //Change this path
	
	MA_SetClock(0.5)		//For sill-images, without running clock
	
	global_settings		{ assumed_gamma 1.0 }
	#default {	finish { ambient 0.01 diffuse 0.99 }	}
	
	#declare LigVector			= <10,20,-10>*100;
	#declare CamLookAt			= <0,0,0>;
	#declare CamLocation		= <1 , 5 ,-25>; //
	#declare CamAngle			= 50;
	#declare CamSky				= <0,1,0>;
	//#declare CamRotate			= <0,180,0>;
	//#declare CamType			= "ultra_wide_angle";


	//Choose an example.
	//Only the last "x" gets generated (easier to switch from one to the other)
	#local xExample	= "simple";
	#local Example	= "asdf";

	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#if (xExample = "simple")
	
		#declare LigVector   = <10,3,-10>*100;
		#declare CamLocation = <0,0,0>;
		#declare CamLookAt   = <0,0,0>;
		#declare CamLookAt   = <0,0,1>;
		#declare CamAngle    = 90;
		//#declare CamAngle    = 180;
		#declare CamType     = "ultra_wide_angle";
		//#local CamRotate	= <0,180,0>;

		#include "mad_universe_stars__1k_max.inc"
		//#include "mad_universe_stars__5k_max.inc"
		#include "mad_universe_constborders.inc"	
		#include "mad_universe_constlines.inc"	
		
		#declare UNI_Stars_StarsSizeFactor        = 6.5;	//def 2.5
		#declare UNI_Stars_Milkiway_Size          = 4;		//def 6
		#declare UNI_Stars_Milkiway_Intensity     = 0.05;	//def 0.04
		#declare UNI_Stars_ConstLineSizeFactor    = 0.5;    //def 0.5
		#declare UNI_Stars_ConstBorderSizeFactor  = 0.8;	//def 0.8
		
		//Parameter 1: horizontal (+ => move stars to the right, - => left)
		//Parameter 2: vertical   (+ => up, - => down)
		//Examples:
		#declare UNI_Stars_Rotation = <-115,30>; //Scorpion
		#declare UNI_Stars_Rotation = <55,-25>;  //Plejades
		#declare UNI_Stars_Rotation = <-80,-35>; //Lyrae and Vega
		#declare UNI_Stars_Rotation = <160,-16>; //Big Lion
		#declare UNI_Stars_Rotation = <-70,-28>; //Summertriangle
		#declare UNI_Stars_Rotation = <85,-8>;   //Orion, bit lower
		#declare UNI_Stars_Rotation = <80,0>;    //Orion
		#declare UNI_Stars_Rotation = <230,+40>; //Scorpion
		#declare UNI_Stars_Rotation = <-90,-90>; //North pole
		
		sky_sphere {
			UNI_GetPigment_BackgroundStars()
			UNI_GetPigment_Milkyway()
		}
		object {
			union {
				object { UNI_GetConstBorders() }
				object { UNI_GetConstLines() }
				object { UNI_GetStars() }
			}
		}

		//maybe running on my computer only, to create test-images.
		#if (0)
			#local mSkyfakes = "../ma_skyfakes_v1/ma_skyfakes_v1.inc";
			#if (file_exists(mSkyfakes))
				#include mSkyfakes
				object {
					SF_GetGasgiant1_Base(true) 
					scale 2
					translate <12,3,40>
				}
			#end

			#local mTussi = "../ma_tussi_v1/ma_tussi_v1.inc";
			#if (file_exists(mTussi))
				#include mTussi
				#declare TU_Thruster_Box_Color		= color Gray30;
				#declare TU_Thruster_Nozzele_Color	= color Gray10;
				
				#local Tussi = TU_GetTussi_Base ("", "", "body-dia: 3;engine-height:1;sc-angle: 90 ;sc-tilt:110;sc-wing-height: 7;sc-panels: 4");
				
				object {
					Tussi
					scale 0.7
					rotate <65,50,0>
					translate <-4,-1,15>
				}
			#end
		#end
	
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "afwrfadf")
	
	
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#else
		//Warning, no existing example choosen
		//DoNothingLoop()
	#end


	MA_CameraAndLight_Set()

		
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
#else
	//File was included, dont generate any output

#end







/*

#macro UNI_GetPigment_Sun()

	//Visible Diameter of the Sun is about 0.52 degrees, divided by 2 for Radius and another 2 for Scale-Factor (see below, Sun-Pigment)
	#local SunRadVis	= 1/360*0.52/2/2;		
	#local SunBody		= SunRadVis / 2;	//Radius of the visible, solid Sun-Body 
	#local SunHalo		= SunRadVis * 20 / 2;	//Radius of the glowing halo around the Sun

	#local mResult = pigment {
		gradient -z
		color_map {
			[0.00 SunBody		color rgb <1.0, 0.2, 0.0> * 6
								color rgb <1.0, 0.2, 0.0> * 1.5 ]
			[SunBody SunHalo	color rgbt <0.6, 0.08, 0.0, 0.8>
								color rgbt <0.0, 0.0, 0.0, 1> ]
			[SunHalo 1			color rgbt <0.0, 0.0, 0.0, 1>
								color rgbt <0.0, 0.0, 0.0, 1> ]
		}
		scale 2	//Important, otherwise at 90 Degrees something like a Halo or Horizont will be visible. http://wiki.povray.org/content/Reference:Sky_Sphere
		translate -1 //Dont know what this does, BUT ITS IMPORTANT.
		
		#if (1)
			#ifdef (UNI_LightVector_Rect)
				#ifdef (UNI_LightVector_Decl)
					rotate <-UNI_LightVector_Decl, -UNI_LightVector_Rect+90, 0>
				#end
			#end

			//UNI_LightVector
			
		#else
			rotate -30*x //Das hier noch mit dem Light-Vector in Einklang bringen.
		#end
	}
	pigment { mResult }
#end



			//y => more positive Values moves stars/constellation to the right
			//y = 0 Pegasus, 90 = Orion, 180 = Big Lion, 270/-90 = Lyra/Vega 
			//x = 0 => Ecliptic in the center, x = 90 => north pole in center
			//A standard-rotate (rotate <45,90,0>) will not show the expected results due to povrays order of execution
			//Instead rotate Y at first (left/right), than X (up/down).
			//Example for a central-european summersky: rotate y*290 rotate x*25
			
			//rotate y*85 rotate x*-1		//Orion
			//rotate y*290 rotate x*25		//Sommerdreieck
			//rotate y*155
			//rotate y*55
			




*/







//-----------------------------------------------------------------------------------------------------------------------------
//This is the end of the very first If (that checks if this file was included before)
//Never delete it, or else ...
	#version UNI_Povray_Stars_Temp;
#end
//-----------------------------------------------------------------------------------------------------------------------------

