//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------
#ifndef( MA_Tussi_Temp)
	#declare MA_Tussi_Temp = version;	//raises a parser-warning if the file does not gets included. Ignor it.
	#version 3.7;
	//Here we're still inside an If-Block !! (the first #ifndef)
//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------


/* ****************************************************************************************************************************

--------------------------------------------------------
MA_Tussi_V1
--------------------------------------------------------
Purpose:		Show a simple, small, fast to render Spacecraft
Author:			Martin Seydler
Website:		www.maetes.com
Documentation:	www.maetes.com/en/povray-os/ma_tussi_v1
				www.maetes.com/de/povray-os/ma_tussi_v1
Date:			2018 an later
Version:		1.0 (13. May 2019)
Copyright:		See above (author)
License:		With my code you can do with it whatever you like.
				A mention and a link to my website would be nice, and a hint where to see your results.


Helpful Command-Lines (change the path):
------------------------------------------
povray +Ima_tussi_v1.inc +O_test/ma_tussi_v1.png +w800 +h600 -GR +A
povray +Ima_tussi_v1.inc +O_test/ma_tussi_v1.png +w1200 +h800 +GD +GF -GR +GS +GW +Q9 +A


To open the resulting picture in a Browser (change the path):
-----------------------------------------------------
file:///home/pi/Projekte/povray/bibs/ma_tussi_v1/_test/ma_tussi_v1.png
file:///home/pi/Projekte/povray/bibs/ma_tussi_v1/_test/


Examples:
------------------
See bottom of this file.

*/// **************************************************************************************************************************


#ifndef(Colors_Inc_Temp)	#include "colors.inc"		#end
#ifndef(Textures_Inc_Temp)	#include "textures.inc"		#end


//-------------------------------
//Texture Main Body
//-------------------------------
#ifndef(TU_Spacecraft_Texture)
	#declare TU_Spacecraft_Texture = texture {
		pigment{
			marble scale 0.01 turbulence 0.0
			color_map { 
				//[0.0 color rgb <0.08, 0.08, 0.08>]
				//[1.0 color rgb <0.0 , 0.0 , 0.0 >]
				[0.0 color rgb <0.8, 0.8, 0.8>]
				[1.0 color rgb <0.0 , 0.0 , 0.0 >]
			}
			//http://www.f-lohmueller.de/pov_tut/tex/tex_780d.htm
			warp { cylindrical
				orientation <0,1,0>
				dist_exp 0
			} 
		}
	}
	#if (0)
		#declare TU_Spacecraft_Texture = texture {
			pigment{ rgbf < 0.7, 0.7, 0.7, 0.9> }
			finish { reflection 0.1 phong 1}
		}
	#end
	
#end
//-------------------------------
//Texture Plates front/aft end
//-------------------------------
#ifndef(TU_Spacecraft_Plates_Texture)
	#declare TU_Spacecraft_Plates_Texture =	texture {
		pigment { color Gray15 }
		//pigment { color Red }
		//normal	{ bumps 0.1 scale 0.015 }
		//finish { reflection 1 phong 1}
	}
#end

//-------------------------------
//Small thrusters
//-------------------------------
#ifndef(TU_Thruster_Box_Color)		#declare TU_Thruster_Box_Color		=		color Yellow;				#end
#ifndef(TU_Thruster_Nozzele_Color)	#declare TU_Thruster_Nozzele_Color	=		color Red;					#end
#ifndef(TU_ThrusterBox_Plate_Color)	#declare TU_ThrusterBox_Plate_Color	=		color White;				#end
#ifndef(TU_Thruster_Flame_Texture)
	#declare TU_Thruster_Flame_Texture = texture {
		pigment { rgbf < 0.9, 0.5, 0.5, 0.9> }
		//finish { reflection 0.1 phong 1}
	}
#end

//-------------------------------
//Main engine at the aft end
//-------------------------------
#ifndef(TU_Engine_Box_Color)		#declare TU_Engine_Box_Color		=		color Yellow;				#end
#ifndef(TU_Engine_Nozzle_Texture)
	#declare TU_Engine_Nozzle_Texture = texture {
		pigment{ marble scale 0.03 turbulence 0.0
			color_map{ 
				[0.0 color rgb <0.08, 0.08, 0.08>]
				[1.0 color rgb <0.0 , 0.0 , 0.0 >]
			}
			//http://www.f-lohmueller.de/pov_tut/tex/tex_780d.htm
			warp { cylindrical
				orientation <1,0,0>
				dist_exp 0
			} 
		}
	}
#end
#ifndef(TU_Engine_Flame_Texture)
	#declare TU_Engine_Flame_Texture = texture {
		//pigment{ rgbf < 0.2, 0.2, 0.99, 0.95> }
		pigment{ rgbf < 0.9, 0.3, 0.9, 0.95> }
		//finish { reflection 0.1 phong 1}
	}
#end

//-------------------------------
//Solarcells
//-------------------------------
#ifndef(TU_Solarcells_Mast_Color)		#declare TU_Solarcells_Mast_Color	= color Grey;			#end
#ifndef(TU_Solarcells_Hinge_Color)		#declare TU_Solarcells_Hinge_Color	= color Gray80;			#end
#ifndef(TU_Solarcells_Border_Color)		#declare TU_Solarcells_Border_Color	= color Gray20;			#end
#ifndef(TU_Solarcells_Cells_Color)		#declare TU_Solarcells_Cells_Color	= color rgb <0,0,0.4>;	#end
#ifndef(TU_Solarcells_Cells_Texture)
	#declare TU_Solarcells_Cells_Texture = texture {
		pigment {
			cells scale 0.12 turbulence 0
			color_map { [0.0 color TU_Solarcells_Cells_Color] [1.0 color rgb <0,0,0.0>] }
		}				
		finish { reflection 0.5 ambient 0.75 diffuse 0.9}
	}
#end

//-------------------------------------------------------------------------
//Parameter
//There is no need to change them here.
//Use third parameter of GetTussi_Base() to do that.
//Both gets concatted inside the macro, by default the last found rules.
//object { MA_Tussi_Base("", "", "body-dia: 10") }
//-------------------------------------------------------------------------
#ifndef(TU_Params_Default)
	#declare TU_Params_Default = concat (
		";body-dia: 			4",			//Diameter of the body, not included unfolded solarwings, thusters, thruster-flames
		";body-height:			6",			//Height of the spacecraft-body, not included the impactor at the top, engine and engine-flame
		";engine-height:		2.0",		//Engine-height (box and nozzle together)
		";engine-dia:			1.0",		//Max diameter of the engine-nozzle
		";engine-flame-height:	3",			//Factor, gets multiplied with engine-height
		";engine-flame-dist:	1.1",		//Factor, creates a gap between the nozzle and the flame, with respect to engine-flame-height (1 = no gap, 1.1 a small)
		//";engine-active			",		//use this to activate the engine
		";thruster-size:		0.5",		//Length of a small thruster. Half of it the box, half the nozzle
		";thruster-dia-1:		0.8",		//Inner/smaller diameter
		";thruster-dia-2:		1.5",		//Outer/bigger diameter
		";thruster-flame-dist:	3",			//distance of flame (in thruster-sizes)
		";thruster-flame-length: 20",		//Length of flame (in thruster-sizes)
		";sc-mast-height:		0.5",		//Height of the slim mast (without cells)
		";sc-wing-height:		3",			//Height of all solarpanels together
		";sc-wing-width:		2",			//Width of the solarcells
		";sc-panels:			3",			//Number of solarcell-panels
		";sc-angle:				90",		//0 = Solarcells folded, 90 = unfolded
		";sc-tilt:				-40",		//tilts/rotates the solarcells, 0 => flat on spacecraft-side, + => counterclockwise when seen from with the tip in front
		""
	);
#end



/* ****************************************************************************************************************************
TU_GetTussi()

Creates a simple spacecraft

Params:
	mParentName	
	mNewName	
	xParams
Return:
	Object
*/// **************************************************************************************************************************
#macro TU_GetTussi ()
	   TU_GetTussi_Base ("", "", "")
#end
#macro TU_GetTussi_Base (mParentName, mNewName, xParams)
	//#ifndef( MA_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = MA_Screenplay_GetName(mParentName, mNewName);	#end
	#ifndef( MA_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = SCR_GetName(mParentName, mNewName);		#end
	#ifndef( MA_Logfile_Temp )		#local mFunc = ""; #else #local mFunc = LOG_MacroHeader("TU_GetTussi_Base");	#end

	#local mParams			= concat (TU_Params_Default, ";", xParams);

	#local mRadius			= MA_GetParam_F(mParams, "body-dia", 2) / 2;
	#local mHeight			= MA_GetParam_F(mParams, "body-height", 5);
	#local mThrusterSize	= MA_GetParam_F(mParams, "thruster-size", 0.5);
	#local mSolarWingAngle	= MA_GetParam_F(mParams, "sc-angle", 0) * -1;
	#local mSolarWingTilt	= MA_GetParam_F(mParams, "sc-tilt", 0) + 90;

	
	// -------------------------------
	// Main body of the spacecraft
	// -------------------------------
	#local mCan = union {
		//Plates at front and end
		cylinder { <0,-mHeight/2 - 0.001,0>,	<0,-mHeight/2 + 0.1,0>, mRadius * 1.01  texture { TU_Spacecraft_Plates_Texture	} }
		cylinder { <0, mHeight/2  + 0.001,0>,	<0, mHeight/2 - 0.1,0>, mRadius * 1.01	texture { TU_Spacecraft_Plates_Texture	} }
			
		//Main body
		cylinder { <0,-mHeight/2,0>,			<0,mHeight/2,0>,		mRadius			texture { TU_Spacecraft_Texture			} }
	}
	
	// -------------------------------
	// Small thrusters at all 4 edges
	// At the top and the bottom
	// -------------------------------
	#if (1)
		#local mThrusterBox_t1	= TU_ThrusterBoxFor		( mMyName, "tb-t1", mParams)
		#local mThrusterBox_t2	= TU_ThrusterBoxFor		( mMyName, "tb-t2", mParams)
		#local mThrusterBox_t3	= TU_ThrusterBoxFor		( mMyName, "tb-t3", mParams)
		#local mThrusterBox_t4	= TU_ThrusterBoxFor		( mMyName, "tb-t4", mParams)
		#local mThrusterBox_b1	= TU_ThrusterBoxBack	( mMyName, "tb-b1", mParams)
		#local mThrusterBox_b2	= TU_ThrusterBoxBack	( mMyName, "tb-b2", mParams)
		#local mThrusterBox_b3	= TU_ThrusterBoxBack	( mMyName, "tb-b3", mParams)
		#local mThrusterBox_b4	= TU_ThrusterBoxBack	( mMyName, "tb-b4", mParams)
	#else //for tests only
		#local mThrusterBox_b3	= TU_ThrusterBoxBack	( mMyName, "tb-b3", mParams)
	#end
	
	// -------------------------------
	// Main-Engine at the lower end
	// -------------------------------
	#local mEngine			= TU_MainEngine			( mMyName, "engine", mParams)

	// -------------------------------
	// Solar-Wings
	// -------------------------------
	#ifdef( Ma_Screenplay_Temp )
		#local mSolarWingAngle	= MA_Screenplay_GetNum (mMyName, "", "solar-wing-unfold", 0);
	#end
	#local mSolarWing1		= object { TU_SolarWing		( mMyName, "wing-1", mParams ) rotate <0, -mSolarWingTilt, mSolarWingAngle> translate <mRadius, -2, 0> rotate <0,0,0>} //First z from 0 to -90 to unfold
	#local mSolarWing2		= object { TU_SolarWing		( mMyName, "wing-1", mParams ) rotate <0, +mSolarWingTilt, mSolarWingAngle> translate <mRadius, -2, 0> rotate <0,0,0>} //First z from 0 to -90 to unfold

	// -------------------------------
	// Stitch all of them together
	// -------------------------------
	#if (1)
		#declare mResult = union {
			object { mCan }
			object { mThrusterBox_t1		rotate <0,-90, 0>	translate < 0, mHeight/2 - mThrusterSize/2, mRadius>	rotate <0,  0,0> }
			object { mThrusterBox_t2		rotate <0,-90, 0>	translate < 0, mHeight/2 - mThrusterSize/2, mRadius>	rotate <0, 90,0> }
			object { mThrusterBox_t3		rotate <0,-90, 0>	translate < 0, mHeight/2 - mThrusterSize/2, mRadius>	rotate <0,180,0> }
			object { mThrusterBox_t4		rotate <0,-90, 0>	translate < 0, mHeight/2 - mThrusterSize/2, mRadius>	rotate <0,270,0> }
			object { mThrusterBox_b1		rotate <0,-90, 0>	translate < 0,-mHeight/2 + mThrusterSize/2, mRadius>	rotate <0,  0,0> }
			object { mThrusterBox_b2		rotate <0,-90, 0>	translate < 0,-mHeight/2 + mThrusterSize/2, mRadius>	rotate <0, 90,0> }
			object { mThrusterBox_b3		rotate <0,-90, 0>	translate < 0,-mHeight/2 + mThrusterSize/2, mRadius>	rotate <0,180,0> }
			object { mThrusterBox_b4		rotate <0,-90, 0>	translate < 0,-mHeight/2 + mThrusterSize/2, mRadius>	rotate <0,270,0> }
			object { mEngine				rotate <180,0, 0>	translate < 0,-mHeight/2, 0>	rotate <0,0,0> }
			object { mSolarWing1			rotate <0,45,  0>	translate < 0,0,0> }
			object { mSolarWing2			rotate <0,45+180,0>	translate < 0,0,0> }
		}
	#else //for tests only
		#declare mResult = union {
			object { mCan }
			object { mThrusterBox_b3		rotate <0,-90, 0>	translate < 0,-mHeight/2 + mThrusterSize/2, mRadius>	rotate <0,180,0> }
			object { mEngine				rotate <180,0, 0>	translate < 0,-mHeight/2, 0>	rotate <0,0,0> }
			object { mSolarWing				rotate <0,45,  0>	translate < 0,0,0> }
			object { mSolarWing				rotate <0,45+180,0>	translate < 0,0,0> }
		}
	#end
	mResult
#end





// ****************************************************************************************************************************
//
// Thruster 
//
// Size will always be <1,1,2> (doubled height because box and nozzle are both <1,1,1>)
//
// ****************************************************************************************************************************
#macro TU_Thruster ( mParentName, mNewName, mParams )
	#ifndef( Ma_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = MA_Screenplay_GetName(mParentName, mNewName);	#end
	
	#local mThrusterThrusting = 0;
	//#local mThrusterThrusting = 1;	//for tests only

	#local mFlameDist		= MA_GetParam_F(mParams, "thruster-flame-dist", 3);
	#local mFlameLength		= MA_GetParam_F(mParams, "thruster-flame-length", 20);
	#local mFlameDia1		= MA_GetParam_F(mParams, "thruster-dia-1", 0.8);
	#local mFlameDia2		= MA_GetParam_F(mParams, "thruster-dia-2", 3.5);

	#if (frame_number / 2 = int(frame_number / 2))
		//Allow thrusters to fire at round frame_numbers only
		#ifdef( Ma_Screenplay_Temp )
			#local mThrusterThrusting = MA_Screenplay_GetNum (mMyName, "", "active", 0);
		#end
	#end
	
	#local mResult = union {
		//Box behind the nozzle
		box {
			<0,0,0> <1,1,1> 
			texture {
				pigment{ color TU_Thruster_Box_Color}
				finish { reflection 0.1 phong 1}
			}
		}
		//Nozzle
		cone {
			<1, 0.5, 0.5> 0.2
			<2, 0.5, 0.5> 0.5 open
			texture {
				pigment { color TU_Thruster_Nozzele_Color }
				finish { reflection 0.1 phong 1}
			}
		}
		//Flame (if thruster is activated)
		#if (mThrusterThrusting > 0)
			cone {
				<mFlameDist, 0.5, 0.5>	mFlameDia1
				<mFlameDist + mFlameLength, 0.5, 0.5>	mFlameDia2
				texture { TU_Thruster_Flame_Texture	}
			}
		#end
		translate <-1, 0, -0.5> 		//center all axes
	}
	
	mResult
#end




// ****************************************************************************************************************************
//
// ThrusterBox (Attitude-Control, chemical)
//
// SizeX = the length of the Box (0 = original Size of 5)
//
// ****************************************************************************************************************************

#macro TU_ThrusterBoxFor    ( mParentName, mNewName, mParams )
	object { TU_ThrusterBox ( mParentName, mNewName, mParams ) rotate <0, 90,-90> }
#end
#macro TU_ThrusterBoxBack   ( mParentName, mNewName, mParams )
	object { TU_ThrusterBox ( mParentName, mNewName, mParams ) rotate <0,-90,-90> }
#end

#macro TU_ThrusterBox (mParentName, mNewName, mParams )
	#ifndef( Ma_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = MA_Screenplay_GetName(mParentName, mNewName);	#end

	#local mThrusterSize = MA_GetParam_F(mParams, "thruster-size", 0.5);

	//Dont change them, use thruster-size instead
	#local mThrusterX = 2;	//Height/length of a nozzle/box-pair
	#local mBoxX = 5;
	#local mBoxY = 1;
	#local mBoxZ = 4;

	#local mResult = union {
		box {
			<0,0,0>
			<mBoxX, mBoxY, mBoxZ> 
			texture { 	pigment { color TU_ThrusterBox_Plate_Color }	}
		}
		object { TU_Thruster (mMyName, "t1", mParams ) rotate <  0,  0,  0> translate <mBoxX-mThrusterX/2,1,2.5> }
		object { TU_Thruster (mMyName, "t2", mParams ) rotate <  0, 90,  0> translate <mThrusterX*1.25,1,1> }
		object { TU_Thruster (mMyName, "t3", mParams ) rotate <  0,180,  0> translate <mThrusterX/2,1,2.5> }
		object { TU_Thruster (mMyName, "t4", mParams ) rotate <  0,  0, 90> translate <mThrusterX*1.5,2,3.5> }
		translate <-mBoxX/2, 0,-mBoxZ/2>		// Move Y into > 0 area
		scale mThrusterSize*(1/mBoxX)
	}
	mResult
#end


// ****************************************************************************************************************************
//
// Main-Engine at the aft end of the spacecraft
//
// ****************************************************************************************************************************

#macro TU_MainEngine ( mParentName, mNewName, mParams)
	#ifndef( Ma_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = MA_Screenplay_GetName(mParentName, mNewName);	#end
	
	#local mHeight			= MA_GetParam_F(mParams, "engine-height", 2);
	#local mDia				= MA_GetParam_F(mParams, "engine-dia", 1.5);
	#local mFlameHeightRaw	= MA_GetParam_F(mParams, "engine-flame-height", 3);
	#local mFlameDist		= MA_GetParam_F(mParams, "engine-flame-dist", 1);

	#local mHeightBox		= mHeight * 0.2;
	#local mHeightEngine	= mHeight - mHeightBox;
	#local mDiaBox			= mDia / 3;
	#local mFlameDia		= mDia;

	#local mEngineActive	= MA_GetParam_B(mParams, "engine-active");

	
	#local mResult = union {
		box {
			<-mDiaBox/2,0,-mDiaBox/2> <mDiaBox/2,mHeightBox,mDiaBox/2> 
			texture { pigment { color TU_Engine_Box_Color }	}
		}
		cone {
			<0, mHeightBox, 0> mDia / 8 <0, mHeight, 0> mDia/2 open
			texture { TU_Engine_Nozzle_Texture }
		}
		//Flamme
		#ifdef( Ma_Screenplay_Temp )
			#local mThrusterThrusting = MA_Screenplay_GetNum (mMyName, "", "active", 0);
		#end
		#if (mEngineActive)
			#local mSeed1 = seed (int(MA_Clock * 10));
			#local mSeed2 = seed (int(MA_Clock * 3));
			#local mHeightFlame = mHeight * mFlameHeightRaw + mHeight/5 * rand (mSeed1);
			cone {
				<0, mHeight * mFlameDist, 0> mFlameDia/2 <0, mHeightFlame, 0> mFlameDia/2 + mFlameDia/1.5 * rand (mSeed2)
				texture { TU_Engine_Flame_Texture }
			}
		#end
	}
	
	mResult
#end




// ****************************************************************************************************************************
//
// Solarwing
//
// ****************************************************************************************************************************
#macro TU_SolarWing ( mParentName, mNewName, mParams )
	#ifndef( Ma_Screenplay_Temp )	#local mMyName = ""; #else #local mMyName = MA_Screenplay_GetName(mParentName, mNewName);	#end

	#local mMastHeight		= MA_GetParam_F(mParams, "sc-mast-height",	1);
	#local mWingHeight		= MA_GetParam_F(mParams, "sc-wing-height",	3);
	#local mWingWidth		= MA_GetParam_F(mParams, "sc-wing-width",	2);
	#local mPanels			= MA_GetParam_F(mParams, "sc-panels",		3);

	#local mMastRadius		= mMastHeight / 30;
	#local mWingThickness	= mWingWidth / 30;
	#local mCellThickness	= mWingThickness / 5;
	#local mCellBorder		= mWingThickness * 0.6;		//Metallic border around the cells
	#local mHingeHeight		= mMastRadius*2;			//Space between two Cells
	#local mHingeWidth		= mHingeHeight*4;

	#if (mPanels < 2) 		#local mPanels = 1; #end
	
	//Hinge - Separator between the cells
	#local mHinge = cylinder {
			<0,0,0> ,<0,mHingeWidth,0> ,mHingeHeight/2
			texture { pigment { color TU_Solarcells_Hinge_Color } }
			translate <0,-mHingeWidth/2,0>
			rotate <0,0,-90>
			translate <0,mHingeHeight/2,0>
	}
	#local mResult = union {
		//Mast
		cylinder { <0,0,0> ,<0,mMastHeight,0> ,mMastRadius
			texture { pigment { color TU_Solarcells_Mast_Color } }
		}
		
		#local mWingHeightOne = (mWingHeight - mHingeHeight * (mPanels-1)) / mPanels;
		#for (n, 0, mPanels -1)
			#local mTemp = n * (mWingHeightOne + mHingeHeight);
			//Wing
			box {
				<-mWingWidth/2, mMastHeight + mTemp, -mWingThickness/2>
				< mWingWidth/2, mMastHeight + mTemp + mWingHeightOne, mWingThickness/2> 
				texture { pigment { color TU_Solarcells_Border_Color } }
			}
			//Solarcell (Thin layer atop wing)
			box {
				<-mWingWidth/2 + mCellBorder, mMastHeight + mTemp + mCellBorder, -mWingThickness/2-0.000001>
				< mWingWidth/2 - mCellBorder, mMastHeight + mTemp + mWingHeightOne - mCellBorder, +mWingThickness/2+0.000001> //Cells on both sides
				//< mWingWidth/2 - mCellBorder, mMastHeight + mTemp + mWingHeightOne - mCellBorder, -mWingThickness/2-mCellThickness> //Cells only on one side
				texture { TU_Solarcells_Cells_Texture }
			}
			//Hinge - Separator between the cells
			#if (n < mPanels-1)
				object { mHinge translate <0,mMastHeight + mTemp + mWingHeightOne,0> }
			#end
		#end
	}
	
	mResult
#end













/* ****************************************************************************************************************************

Example-Output

This will only work if you execute the file directly, instead of including it (see command-lines at the top of this file).
If you use it as an include-file, no output will be generated, all the lines from here on will be useless text.
See:
http://povray.org/documentation/3.7.0/r3_2.html#r3_2_5_2

Nevertheless there is no reason to delete the examples, parsing isnt the thing that slows down the render-process.

*/// **************************************************************************************************************************


#if (input_file_name = "ma_tussi_v1.inc")
	
	//#include "../ma_helpers_v1/ma_helpers_v1.inc" //Change this path
	#include "ma_helpers_v1.inc" //Change this path
	
	MA_SetClock(0.5)		//For sill-images, without running clock
	
	global_settings		{ assumed_gamma 1.0 }
	#default {	finish { ambient 0.01 diffuse 0.99 }	}
	
	#declare LigVector			= <10,20,-10>*100;
	#declare CamLookAt			= <0,0,0>;
	#declare CamLocation		= <1 , 5 ,-25>; //
	#declare CamAngle			= 55;
	//#declare CamRotate			= <0,180,0>;
	//#declare CamType			= "ultra_wide_angle";


	//Choose an example.
	//Only the last "x" gets generated (easier to switch from one to the other)
	#local xExample	= "simple";
	#local xExample	= "examplepic-1";
	#local Example	= "examplepic-2";
	#local Example	= "asdf";

	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#if (xExample = "simple")
	
		//MA_Terminal_S("Param-1", MA_GetParam_S("bingo: zappel; hallo; num:1", "bingo", "nix"))
	
		#local mSkyfakes = "../ma_skyfakes_v1/ma_skyfakes_v1.inc";
		#if (file_exists(mSkyfakes))
			#include mSkyfakes
			sky_sphere {
				SF_GetBackgroundStars(2,5)
			}
			object {
				SF_GetHorizon1_Base ( 100, 0.1, "l", <0,195,0>, 2) //Diameter, Orbit-Height, Position, Rotation, Clounds (0-2)
				//translate <100000,0,10000>
			}
		#end
		#local Params = "lolo: hallo;"
		
		#local Tussi = TU_GetTussi_Base ("", "", Params);
		
		object {
			Tussi
			scale 1
			rotate <45,0,0>
			//rotate <30,0,0>
			//translate <-4,-4,0>
		}
		//MA_Terminal_S("num", MA_GetParam_S("bingo: zappellll; hallo; num:1", "num", "nix"))
		
	//-----------------------------------------------------------------------------------------------------------------------
	// Example 1
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "examplepic-1")

		#local mSkyfakes = "../ma_skyfakes_v1/ma_skyfakes_v1.inc";
		#if (file_exists(mSkyfakes))
			#include mSkyfakes
			sky_sphere {
				SF_GetBackgroundStars(1.5,1)
			}
		#end

		#local Params = "sc-angle:0;sc-tilt:0;engine-active;engine-flame-dist:1.3"
		object {
			TU_GetTussi_Base ("", "", Params)
			scale 1
			rotate <65,80,0>
			//rotate <30,0,0>
			//translate <-4,-4,0>
		}
	
	//-----------------------------------------------------------------------------------------------------------------------
	// Example 2
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "examplepic-2")
	
		#declare LigVector			= <-10,20,-10>*100;

		#local mSkyfakes = "../ma_skyfakes_v1/ma_skyfakes_v1.inc";
		#if (file_exists(mSkyfakes))
			#include mSkyfakes
			sky_sphere {
				SF_GetBackgroundStars(1.5,1)
			}
		#end
		#local Params = "sc-angle:90;sc-tilt:-75;sc-wing-height:6;sc-wing-width:2;sc-panels:5;engine-height:1.0;body-dia:3; thruster-size:0.6"
		#declare TU_Spacecraft_Plates_Texture =	texture {
			pigment { color <0.4,0.2,0.2>*2.0 }
			normal	{ bumps 0.1 scale 0.010 }
			finish { reflection 1 phong 1}
		}

		#declare TU_Spacecraft_Texture = texture {
			pigment { color rgb <0.9, 0.9, 0.9> }
			//normal	{ bumps 0.2 scale 0.5 }	//Größeres Bumps = höhere Schatten. Scale x+z-Größe der Schatten
			normal	{ bumps 0.7 scale 0.1 }	//Gekrissel (Sandgestrahlt? statt sowas wie Hitzeschutz-Folien
			finish	{ ambient 0.1 phong 1}	//Ambient = Schattenhelligkeit (Leider aller Schatten, nicht nur der durch Normal erzeugten)
		}
		#declare TU_Thruster_Box_Color		= color <1,1,1>/9;
		#declare TU_Thruster_Nozzele_Color	= color <3,3,3>/9;
		#declare TU_ThrusterBox_Plate_Color	= color White;
		#declare TU_Engine_Box_Color		= color <5,5,5>/9;


		
		object {
			TU_GetTussi_Base ("", "", Params)
			scale 1.2
			rotate z*50
			rotate <30,90,0>
			//rotate <30,0,0>
			//translate <-4,-4,0>
		}
	
	//-----------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "afwrfadf")
	
	
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#else
		//Warning, no existing example choosen
		//DoNothingLoop()
	#end


	MA_CameraAndLight_Set()

		
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
#else
	//File was included, dont generate any output

#end









//-----------------------------------------------------------------------------------------------------------------------------
//This is the end of the very first If (that checks if this file was included before)
//Never delete it, or else ...
	#version MA_Tussi_Temp;
#end
//-----------------------------------------------------------------------------------------------------------------------------
