//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------

#ifndef( MA_Skyfakes_Temp)
	#declare MA_Skyfakes_Temp = version;	//raises a parser-warning if the file does not gets included. Ignor it.
	#version 3.7;

	//Here we're still inside an If-Block !! (the first #ifndef)

//-----------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------


/* ****************************************************************************************************************************

--------------------------------------------------------
MA_Skyfakes_V1
--------------------------------------------------------
Purpose:		Present some easy and more or less fast to render planets and other objects of the sky.
Author:			Martin Seydler
Website:		www.maetes.com
Documentation:	www.maetes.com/en/povray-os/ma_skyfakes_v1
				www.maetes.com/de/povray-os/ma_skyfakes_v1
Date:			November 2018 an later
Version:		1.0 (april 2019)
Copyright:		See above (author), below near any macro (orignal author and sources) and everywhere (www.povray.org)
License:		With my code you can do with it whatever you like. A mention and a link to my website would be nice.


Helpful Command-Lines (change the path):
------------------------------------------
povray +Ima_skyfakes_v1.inc +O_test/ma_skyfakes_v1.png +w800 +h500 -GR +A
povray +Ima_skyfakes_v1.inc +O_test/ma_skyfakes_v1.png +w1200 +h800 +GD +GF -GR +GS +GW +Q9 +A

To open the resulting picture in a Browser (change the path):
-----------------------------------------------------
file:///home/pi/Projekte/povray/bibs/ma_skyfakes_v1/_test/ma_skyfakes_v1.png
file:///home/pi/Projekte/povray/bibs/ma_skyfakes_v1/_test/

General Idea:
------------------
This script generates some easy and simple to render Sky-Stuff.
Maybe not the most realistic, some only look nice with a few 100 px or less in size.
But that should enough to place somewhere beneath your primary objects.
For more realistic planets, horizons, starmaps and so on see (somewhen Q2/Q3-2019) www.mates.com/en/povray-os/
All macros are prepared for copy-paste into your own script, they dont need global variables, maps or other include-stuff.
At least half of the examples i have found somewhere in the internet and wanted them to save in one file.
In this case the original Websites are mentioned.

Beware:
----------------
All examples are optimized for a camera-angle of 90 deg and camera-type ultrawideangle.
The size of one povray-unit for the planetary body, rings appear bigger.
Especially atmospheres and bozo-patterns react very strange if you scale them,
so prepare yourself to get unfriendly results and adjust some variables.
Sometimes i will mention what values are nice for other scale-factors.


Feel free to contact me if you have found or self-created (really) nice and easy to render ...
------------------------------------------------------------------------------------------------
- Planets, Moons
- irregulare Asteroids
- Comets
- Nebulaes, Galaxies
- or whatelse there above can be seen


Examples:
------------------
See bottom of this file.


Some notes for me, maybe other planets
------------------------------------------
http://www.hoboes.com/NetLife/POV_Simple/POV_Simple_HTML/

Ring-Planet
http://lib.povray.org/searchcollection/index2.php?objectName=NXPlanets&version=1.1&contributorTag=Nekar%20Xenos

Generell paar Texturen, bisl genauer hingucken, paar recht weit unten
http://lib.povray.org/searchcollection/index2.php

Maybe for another planet/moon:
http://f-lohmueller.de/pov_tut/tex/tex_880e.htm

*/// **************************************************************************************************************************





#ifndef(Colors_Inc_Temp)	#include "colors.inc"		#end







/* ****************************************************************************************************************************
SF_GetBackgroundStars

Paints countless background-stars onto the skysphere

Source:
	http://www.hoboes.com/NetLife/POV_Simple/5/2/
	http://wiki.povray.org/content/Reference:Sky_Sphere
	
Example:
	sky_sphere {	SF_GetBackgroundStars(2,5)		}
	
Params:
	Density		Number of stars, use values between 0 and 10 (1 default). 
	Size		Size/brightness of the biggest stars, use values between 0 and 10 (1 default). 
	The parameters affects each other, so combine both to find a good visual appearance.

Return:
	Pidgment:	Fill it into a sky-sphere (dont use as a object)
*/// **************************************************************************************************************************
#macro SF_GetBackgroundStars (Density, Size)
	#local mResult = pigment {
		bozo
		color_map {
			[0.0 color <1,1,1>*3]
			[0.2 + (0.01*Density) color <0,0,0>]
			[1.0 color <0,0,0>]
		}
		scale .0015 * Size/2
	}
	pigment { mResult }
#end
	


	
	

/* ****************************************************************************************************************************
SF_GetBackgroundSun

Paints a sun onto the skysphere
This does not affect the vector of the real-lightsource!
But its much faster to render than an object with a halo/media around it.

Sources:
	http://wiki.povray.org/content/Reference:Sky_Sphere

Example:
	sky_sphere {
		SF_GetBackgroundSun(1,1,-20,30) //Creates a sun near the end of the positive z-axis (littlebit up/left of it).
	}
	
Params:
	BodyScale	scales the size of the suns body (1 uses the untouched, realistic value, > 1 means bigger body)
	HaloScale	scales the size of the surrounding halo (1 = untouched, < 1 smaller, > 1 bigger, as above)
	RotateX		Float/Degrees (-90 to 90)  , moves sun down (-) or up (+)
	RotateY		Float/Degrees (-180 to 180), moves sun to the left (-) or right (+)

Return:
	Pidgment:	Fill it into a sky-sphere (dont use as a object)
*/// **************************************************************************************************************************
#macro SF_GetBackgroundSun(BodyScale, HaloScale, RotateX, RotateY)

	//Visible Diameter of the Sun is about 0.52 degrees, divided by 2 for Radius and another 2 for Scale-Factor (see below, Sun-Pigment)
	#local SunRadVis	= 1/360*0.52/2/2;					//Original radius of the sun
	#local SunBody		= BodyScale * SunRadVis / 2;		//Radius of the visible, solid Sun-Body 
	#local SunHalo		= HaloScale * SunRadVis * 20 / 2;	//Radius of the glowing halo around the Sun

	#local mResult = pigment {
		gradient -z
		color_map {
			[0.00	 SunBody	color rgb <1.0, 0.2, 0.0> * 6				color rgb <1.0, 0.2, 0.0> * 1.5	]
			[SunBody SunHalo	color rgbt <0.6, 0.08, 0.0, 0.8>			color rgbt <0.0, 0.0, 0.0, 1>	]
			[SunHalo 1			color rgbt <0.0, 0.0, 0.0, 1>				color rgbt <0.0, 0.0, 0.0, 1>	]
		}
		scale 2						//Important, otherwise at 90 Degrees something like a Halo or Horizon will be visible.
		translate -1				//Dont know what this does, BUT ITS IMPORTANT too.
		rotate <RotateX, RotateY, 0>
	}
	pigment { mResult }
#end






/* ****************************************************************************************************************************
*******************************************************************************************************************************
SF_GetGasgiant1

Creates a simple Planet, optionally with a saturn-like ringsystem.

Example:
	object { SF_GetGasgiant1() }
	
Params:
	ShowRings	if the Ringsystem gets displayed or not (true/false)

Return:
	Object
*******************************************************************************************************************************
*/// **************************************************************************************************************************

#macro SF_GetGasgiant1 ()
	object { SF_GetGasgiant1_Base(true) }
#end

#macro SF_GetGasgiant1_Base(ShowRings)

	// jupiter-like planet
	// Borrowed from Bob H. - see http://objects.povworld.org/cat/Space/
	#local Result = sphere {
		0,1
		texture {
			pigment {
				gradient y turbulence .05 frequency -1
				color_map {
					[0 color rgb <.85,.8,.725>] // poles
					[.05 color rgb <.875,.875,.775>]
					[.15 color rgb <.925,.875,.825>]
					[.25 color rgb <.9,.875,.85>]
					[.275 color rgb <.825,.8,.775>]
					[.33 color rgb <.925,.85,.875>]
					[.45 color rgb <.975,.95,.925>]
					[.54 color rgb <.85,.6,.75>]
					[.55 color rgb <.95,.55,.4>] // Great Red Spot
					[.56 color rgb <.9,.95,.85>]
					[.6 color rgb <.85,.8,.875>]
					[.65 color rgb <.8,.45,.55>]
					[.725 color rgb <.725,.55,.4>] // dark bands
					[.8 color rgb <.725,.575,.425>]
					[.9 color rgb <.85,.7,.725>]
					[.95 color rgb <.75,.725,.775>]
					[1 color rgb <.95,.8,.75>] // equator
				}
				scale <.2,1,.2> rotate 15*y translate -.05*y
				warp {
					black_hole <.5,-.5,-.8>,.25 falloff .3 strength 1.2 turbulence 0 inverse
				}
			}
			finish {ambient .03 diffuse .55 phong .075 phong_size 1.5 specular .025 roughness .01}
		}
		scale <1,.91,1>  // still of 1 POV unit size
	}	
	//Saturn-Ringsystem, here in thousands km, so divide by the factor (see disc{ ...} )
	#local mFactor = 40;
	#local RingData = array[6][7] {
		{  74.500,  92.000, 0.90, 0.88, 0.79, 0.6, 0.4 }	//C ring (innermost, more translucent) 
		{  92.000,  98.390, 0.99, 0.88, 0.79, 0.2, 0.4 } 	//Inner B ring (translucent) 
		{  98.390, 117.500, 0.99, 0.88, 0.79, 0.1, 0.4 }	//Outer B ring (solid, inside Cassini Division) 
		{ 122.200, 133.570, 0.99, 0.88, 0.79, 0.1, 0.4 }	//Inner A ring (between Cassini and Encke divisions) 
		{ 133.895, 136.800, 0.99, 0.88, 0.79, 0.2, 0.4 }	//Outer A ring (outside Encke division) 
		{ 140.210, 140.460, 0.99, 0.88, 0.79, 0.1, 0.1 } 	//F ring (solid, outermost thin ring) 
	}

	#if (ShowRings)
		#local RingSystem = object {  sphere {	<0, 0, 0>, 0.001	}  }; //only to prevent union {} from crying
		#for (i, 0, dimension_size(RingData,1) - 1)
			#local RingSystem = union {
				object { RingSystem }
				disc { 
					<0, 0, 0>	y,
					RingData[i][1] / mFactor,
					RingData[i][0] / mFactor
					pigment {color rgbt <RingData[i][2], RingData[i][3], RingData[i][4], RingData[i][5]>} 
					finish {ambient 0 diffuse RingData[i][6]} 
					double_illuminate
				} 
			}
		#end
		#local Result = union {
			object { Result } 
			object { RingSystem }
		}
		
	#end
	
	object { Result }

#end





/* ****************************************************************************************************************************
*******************************************************************************************************************************
SF_GetHorizon1()

Creates a simple horizon.
Colors: blue, green, brown, white clouds.

Links:
	http://www.povray.org/documentation/view/3.7.0/77/
	https://duckduckgo.com/?q=povray+planet+earth&t=ffsb&ia=web

Example:
	object { SF_GetHorizon1_Base ( 10000, 100, "b", <0,0,0>, 1) }
	
Params:
	mDia		diameter of the horizon in kilometer (!). Choose a value much bigger than the foreground-object (10000)
	mHeight		height above the planet (distance to <0,0,0>), also in kilometer
	mPosition	where the horizon has to appear (left, right, top, bottom, also l,r,t,b allowed).
	mRotation	rotation-vector, to look for nicer scenes or to let rotate it in animations
	mClouds		number of cloud-layers (0,1,2 allowed). the more clouds the longer the time to render
Return:
	Object
*******************************************************************************************************************************
*/// **************************************************************************************************************************

// -------------------------------
// Textures for MA_GetHorizon1()
// -------------------------------

#declare SF_Horizon1_LandArea = texture {
	pigment {
		agate
		//gradient x
		turbulence 1
		lambda 1.5
		omega .8
		octaves 8
		//scale 1000000
		color_map {
			[0.00 color rgb <.5, .25, .15>]
			[0.33 color rgb <.1, .5, .4>]
			[0.86 color rgb <.6, .3, .1>]
			[1.00 color rgb <.5, .25, .15>]
		}
	}
	//normal { bumps 1 scale 30000000 }
}

	
#declare SF_Horizon1_OceanArea = texture {
	pigment {
		bozo
		turbulence 1.0
		lambda 3
		color_map {
			[0.00, 0.4 color rgb <0, 0, 1> 		color rgb <0, 0, 1>]
			[0.4, 0.6 color rgbf <1, 1, 1, 1>     color rgbf <1, 1, 1, 1>]
			[0.6, 1.00 color rgb <0, 0, 1>		color rgb <0, 0, 1>]
		}
	}
}

#declare SF_Horizon1_CloudArea1 = texture {
	pigment {
		agate
		turbulence 1
		lambda 2
		frequency 2
		color_map {
			[0.0 color rgbf <1, 1, 1, 1>]
			[0.5 color rgbf <1, 1, 1, .35>]
			[1.0 color rgbf <1, 1, 1, 1>]
		}
	}
}


#declare SF_Horizon1_Clouds1 = pigment {
	bozo
	turbulence 1
	color_map {
		[0.0 color White filter 1]
		[0.5 color White]
		[1.0 color White filter 1]
	}
	color_map {
		[0.0 color White filter 1]
		[0.4 color White filter 1]
		[0.5 color White]
		[0.65 color White filter 1]
		[1.0 color White filter 1]
	}
}
#declare SF_Horizon1_Clouds2 = pigment {
	agate
	turbulence 1
	color_map {
		[0.0 color White filter 1]
		[0.4 color White filter 1]
		[0.5 color White]
		[0.6 color White filter 1]
		[1.0 color White filter 1]
	}
}
#declare SF_Horizon1_Clouds3 = pigment {
	marble
	turbulence 1
	color_map {
		[0.0 color White filter 1]
		[0.4 color White filter 1]
		[0.5 color White]
		[0.6 color White filter 1]
		[1.0 color White filter 1]
	}
}

#declare SF_Horizon1_Clouds4 = pigment {
	granite
	turbulence 1
	color_map {
		[0.0 color White filter 1]
		[0.4 color White filter 1]
		[0.5 color White]
		[0.6 color White filter 1]
		[1.0 color White filter 1]
	}
}

#declare SF_Horizon1_CloudArea2 = texture {
	pigment {
		gradient y
		pigment_map {
			[0.00 SF_Horizon1_Clouds1]
			[0.25 SF_Horizon1_Clouds2]
			[0.50 SF_Horizon1_Clouds3]
			[0.75 SF_Horizon1_Clouds4]
			[1.00 SF_Horizon1_Clouds1]
		}
	}
}
#declare SF_Horizon1_CloudArea3 = texture {
	pigment {
		gradient y
		pigment_map {
			[0.00 SF_Horizon1_Clouds1]
			[0.50 SF_Horizon1_Clouds3]
			[1.00 SF_Horizon1_Clouds1]
		}
	}
}

// -------------------------------
// The macros itself
// -------------------------------
#macro SF_GetHorizon1   ( mPosition, mRotation, mClouds)
	SF_GetHorizon1_Base ( 5000, 100, mPosition, mRotation, mClouds)
#end
#macro SF_GetHorizon1_Base ( mDia, mHeight, mPosition, mRotation, mClouds)

	//Dia and Height given in km, so multiply by 1000
	#local mPlanetRadius	= mDia / 2 * 1000; 
	#local mHeight			= mHeight * 1000;	//Height above Surface (ISS = 300 km)
	#local mDistance		= mPlanetRadius + mHeight * 1;
	
	#if		(mPosition = "l" | mPosition = "left")		#local mTransVector	= < -mDistance, 0, 0>;
	#elseif (mPosition = "r" | mPosition = "right")		#local mTransVector	= < +mDistance, 0, 0>;
	#elseif (mPosition = "t" | mPosition = "top")		#local mTransVector	= < 0, +mDistance, 0>;
	#else												#local mTransVector	= < 0, -mDistance, 0>;
	#end
	
	/*
	object {
		//no_reflection
		//no_image
		//double_illuminate
	}
	*/


	object {
		sphere {
			<0,0,0>, mPlanetRadius
			texture { SF_Horizon1_LandArea				scale mPlanetRadius/10 }
			texture { SF_Horizon1_OceanArea			scale mPlanetRadius/12 }
			#if (mClouds >= 1)	texture { SF_Horizon1_CloudArea3			scale mPlanetRadius/12 } 	#end
			#if (mClouds >= 2)	texture { pigment { SF_Horizon1_Clouds1 }	scale mPlanetRadius/12 }	#end
		}
		rotate mRotation
		translate mTransVector
	}
#end

// ****************************************************************************************************************************
// End Horizon-1
// ****************************************************************************************************************************














/* ****************************************************************************************************************************

Example-Output

This will only work if you execute the file directly, instead of including it.
If you use it as an include-file, no output will be generated, all the lines from here on will be useless text.
See:
http://povray.org/documentation/3.7.0/r3_2.html#r3_2_5_2

Nevertheless there is no reason to delete the examples, parsing isnt the thing that slows down the render-process.

*/// **************************************************************************************************************************


#if (input_file_name = "ma_skyfakes_v1.inc")
	
	#macro SF_SetMyClock(mValue)
		#if (clock_on = 0)
			#declare SF_MyClock		= mValue;		//Standard-Value if clock isnt running
		#else
			#declare SF_MyClock		= clock;
		#end
	#end
	
	SF_SetMyClock(0.5)		//For sill-images, without running clock
	
	global_settings		{ assumed_gamma 1.0 }
	#default {	finish { ambient 0.01 diffuse 0.99 }	}

	//To place the visible sun and the invisible Light-Vector at the same location
	#local SunRotateX = -10; //down (+) or up (-). Seems unlogically, but its the normal rotation of the X-Vector.
	#local SunRotateY = +20; //right (+) or left (-).


	//Choose one example. The star-background will be generated all the time, so it doesnt look too boring
	//Only the last "x" gets generated (easier to switch from one to the other)
	#local xExample	= "all";
	#local Example	= "stars";
	#local Example	= "sun-and-stars";
	#local Example	= "gasgiant-1";
	#local Example	= "horizon-1";
	#local Example	= "perspective";
	#local Example	= "asdf";

	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#if (xExample = "all")
		sky_sphere {
			SF_GetBackgroundStars(2,5)
			SF_GetBackgroundSun(1,1,0,0)
			rotate <SunRotateX,SunRotateY,0>
		}
		object {
			SF_GetGasgiant1_Base(true) 
			scale 3
			rotate <-5,0,+5>
		}
		object {
			SF_GetHorizon1_Base ( 10000, 100, "b", <0,0,0>, 1) //Diameter, Orbit-Height, Position, Rotation, Clounds (0,1,2)
		}
		
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "stars")
		sky_sphere {
			SF_GetBackgroundStars(2,5)
		}
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "sun-and-stars")
		sky_sphere {
			SF_GetBackgroundStars(2,5)
			SF_GetBackgroundSun(1, 1, 0, 0)
			rotate <SunRotateX,SunRotateY,0>
		}
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "gasgiant-1")	//
		sky_sphere {
			SF_GetBackgroundStars(2,5)
			SF_GetBackgroundSun(1, 1, 0, 0)
			rotate <SunRotateX,SunRotateY,0>
		}
		object {
			SF_GetGasgiant1_Base(true) 
			scale 3
			rotate <-5,0,+5>
		}
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "horizon-1")	//
		sky_sphere {
			SF_GetBackgroundStars(2,5)
			SF_GetBackgroundSun(1, 1, 0, 0)
			rotate <SunRotateX,SunRotateY,0>
		}
		object {
			SF_GetGasgiant1_Base(true) 
			scale 3
			rotate <-5,0,+5>
		}
		object {
			SF_GetHorizon1 ( "b", <0,0,0>, 1) 						//Position, Rotation, Clounds (0,1,2)
			//SF_GetHorizon1_Base ( 10000, 100, "b", <0,0,0>, 1) 	//Diameter, Orbit-Height, Position, Rotation, Clounds (0,1,2)
			//rotate <x,y,z> //DONT USE THIS, because the horizon is off-axis by thousands of pu! Use the makro-parameter instead.
		}
	//-----------------------------------------------------------------------------------------------------------------------
	// FOR INTERNAL USE ONLY
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "perspective")	//
		#local SunRotateX = -0; //down (+) or up (-)
		#local SunRotateY = +160; //right (+) or left (-)
		sky_sphere {
			SF_GetBackgroundStars(2,5)
			SF_GetBackgroundSun(1, 1, -20, +35)
			SF_GetBackgroundSun(1, 1, -20, -35)
			//rotate <SunRotateX,SunRotateY,0>
		}
		object {
			SF_GetGasgiant1_Base(0) 
			scale 4
			translate <0,5,5>
		}
		object {
			SF_GetHorizon1_Base ( 10000, 100, "b", <0,0,0>, 1) //Diameter, Orbit-Height, Position, Rotation, Clounds (0-2)
			//rotate <x,y,z> //DONT USE THIS, because the horizon is off-axis by 1000000 pu! Use the makro-parameter instead
		}
	//-----------------------------------------------------------------------------------------------------------------------
	// FOR INTERNAL USE ONLY
	// Needs a still to be finished package.
	//-----------------------------------------------------------------------------------------------------------------------
	#elseif (xExample = "tussi")
		#local SunRotateX = 20;		//down (+) or up (-)
		#local SunRotateY = +120;	//right (+) or left (-)
		sky_sphere {
			SF_GetBackgroundStars(2,5)
		}
		object {
			union {
				object {
					SF_GetGasgiant1_Base(true) 
					scale 2
					rotate <-15,-45,+15>
				}
				object {
					SF_GetGasgiant1_Base(false) 
					scale 0.6
					translate <10,0,00>
				}
			}
			scale 60
			translate <50,1000,3000> 
		}
		
		object {
			SF_GetHorizon1_Base ( 100, 0.1, "l", <180,15,0>, 2) //Diameter, Orbit-Height, Position, Rotation, Clounds (0-2)
			//translate <100000,0,10000>
		}
		
		#local TussiFile = "ma_tussi_v1/ma_tussi_v1.inc";
		#if (file_exists(TussiFile))
			#include TussiFile
			#local Tussi = maSpacecraft ("", "");
			object {
				Tussi
				scale 2
				rotate <45,0,0>
				translate <-4,-4,0>
			}
			
		#end
	
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
	#else
		//Warning, no existing example choosen
		//DoNothingLoop()
		
	#end



	//MA_Helpers doesnt exist here, so set all of them manually
	
	//light_source		{ <1,1,10>*100 color <1,1,1> }
	light_source {
		<0,0,10>*100
		color  <1,1,1>
		rotate <SunRotateX,SunRotateY,0>
	}
	camera {
		ultra_wide_angle 	//Better for planes, sun and stars
		//perspective 		//default, better for horizons
		right x*image_width/image_height
		location	<0,2,-30>
		look_at		<0,0,0>
		//look_at		<-5,0,0>
		angle		90
	}

		
	//-----------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------
#else
	//File was included, dont generate any output

#end




//-----------------------------------------------------------------------------------------------------------------------------
//This is the end of the very first If (that checks if this file was included before)
//Never delete it, or else ...
	#version MA_Skyfakes_Temp;
#end
//-----------------------------------------------------------------------------------------------------------------------------
